<?php
session_start();
// It's recommended to enable error reporting for development and disable it for production
// error_reporting(0);
include("../config/theconfig.php");
include("header.php");

// Check if customer is logged in
if (!isset($_SESSION['customerid'])) {
    header('Location: login.php?error=nologin');
    exit(); // Always exit after a header redirect
}

// Prepared statement to select account details based on account number
$stmt = $conn->prepare("SELECT * FROM accounts WHERE accno=?");
$stmt->bind_param("s", $_POST['accno']);
$stmt->execute();
$acc = $stmt->get_result();
$stmt->close();

$Accountnumber = "";
$Accountbalance = "";

if ($rows = $acc->fetch_assoc()) {
    $Accountnumber = $rows["accno"];
    $Accountbalance = $rows["accountbalance"];
}

// Prepared statement to select accounts for the logged-in customer
$stmt = $conn->prepare("SELECT * FROM accounts WHERE customerid=?");
$stmt->bind_param("i", $_SESSION['customerid']);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

?>



<body data-sidebar="colored">
   <!-- <body data-layout="horizontal" data-topbar="dark"> -->
   <!-- Begin page -->
   <div id="layout-wrapper">
      
      <!-- Left Sidebar End -->
      <!-- ============================================================== -->
      <!-- Start right Content here -->
      <!-- ============================================================== -->
      <div class="main-content">
         <?php
// It is assumed that you have a database connection object named $conn available from a separate file.

// Prepared statement to select accounts for the logged-in customer
$stmt_accounts = $conn->prepare("SELECT * FROM accounts WHERE customerid=?");
$stmt_accounts->bind_param("s", $_SESSION['customerid']);
$stmt_accounts->execute();
$result_accounts = $stmt_accounts->get_result();
$rowrec = $result_accounts->fetch_assoc();
$stmt_accounts->close();

// Prepared statement to select fixed deposits for the logged-in customer
$stmt_fixed_deposit = $conn->prepare("SELECT * FROM fixed_deposit WHERE customerid=?");
$stmt_fixed_deposit->bind_param("s", $_SESSION['customerid']);
$stmt_fixed_deposit->execute();
$result_fixed_deposit = $stmt_fixed_deposit->get_result();
$rowrec2 = $result_fixed_deposit->fetch_assoc();
$stmt_fixed_deposit->close();
?>
         <div class="page-content">
            <?
               if(isset($_POST['fixed']))
               {
               $query=mysqli_query($con,"insert fixed_deposit (customerid,accno, amount,duration,status) VALUES ('$_SESSION[customerid]','$_POST[act]','$_POST[amount]','$_POST[duration]','1')");
               ?>
            <script>
               swal('Successful!', 'Your Fixed Deposit Account Has Been Created. Your Fixed Deposit Account Number Is $_POST[act]', 'success') 
               
            </script>
            <?}
               ?>
            <div class="container-fluid">
               <!-- start page title -->
               <div class="row">
                  <div class="col-12">
                     <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Statement Of Account</h4>
                        <div class="page-title-right">
                           <ol class="breadcrumb m-0">
                              <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                              <li class="breadcrumb-item active">Statement Of Account</li>
                           </ol>
                        </div>
                     </div>
                  </div>
               </div>
               <!-- end page title -->
               
               </div>
               <!-- end row -->
              
               <!-- end row -->
               <div class="row">
                  <div class="col-lg-12">
                     <div class="card">
                        <div class="card-body">
                           
                           <div id="datatable_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                           <div class="table-responsive">

<table id="data-table" class="table table-bordered dt-responsive nowrap w-100 dataTable no-footer dtr-inline" role="grid" aria-describedby="datatable_info"> <div class="row">
<thead class="table-light">
      <tr>
												<th>Date</th>
                                                <th>Transaction ID</th>
                                                <th>Account Charges</th>
                                                <th>Withdrawals</th>
                                                <th>Deposits</th>
                                                <th>Withdrawn By</th>
                                                <th>Deposited By</th>
                                                <th>Amount</th>
      </tr>
      </thead>
                                            <tbody>
    
    <?php
// It is assumed that you have a database connection object named $conn available from a separate file.
$customid = $_SESSION['customerid'];
$count = 1;

// Using a prepared statement to prevent SQL injection
$query = "SELECT * FROM transactions WHERE payeeid = ? OR receiveid = ? OR charged = ? ORDER BY paymentdate DESC";
$stmt = $conn->prepare($query);

// Check if the prepare() call was successful
if ($stmt === false) {
    die('Error preparing the statement for transactions: ' . $conn->error);
}

$stmt->bind_param("sss", $customid, $customid, $customid);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

while (($arrvar = $result->fetch_assoc())) {
    echo "<tr>";
    echo "<td>" . $arrvar['paymentdate'] . "</td>";
    echo "<td>" . $arrvar['transactionid'] . "</td>";

    if ($arrvar['payeeid'] == $customid) {
        $recipient_id = $arrvar['receiveid'];
        $q = "SELECT * FROM registered_payee WHERE slno = ?";
        $inner_stmt = $conn->prepare($q);

        // Check if the prepare() call for the inner statement was successful
        if ($inner_stmt === false) {
            die('Error preparing the inner statement: ' . $conn->error);
        }

        $inner_stmt->bind_param("i", $recipient_id);
        $inner_stmt->execute();
        $r = $inner_stmt->get_result();
        $rarry = $r->fetch_assoc();
        $inner_stmt->close();

        echo "<td>" . $_SESSION['customername'] . "</td>";
        echo "<td></td>"; // Placeholder for credit
        echo "<td>" . $cur . $arrvar['amount'] . "</td>"; // Debit amount

    } else if ($arrvar['receiveid'] == $customid) {
        $sender_id = $arrvar['payeeid'];
        $q = "SELECT * FROM customers WHERE customerid = ?";
        $inner_stmt = $conn->prepare($q);

        if ($inner_stmt === false) {
            die('Error preparing the inner statement: ' . $conn->error);
        }
        
        $inner_stmt->bind_param("i", $sender_id);
        $inner_stmt->execute();
        $r = $inner_stmt->get_result();
        $rarry = $r->fetch_assoc();
        $inner_stmt->close();

        echo "<td></td>"; // Placeholder for debit
        echo "<td>" . $_SESSION['customername'] . "</td>";
        echo "<td>" . $cur . $arrvar['amount'] . "</td>"; // Credit amount

    } else if ($arrvar['charged'] == $customid) {
        echo "<td>" . $cur . $arrvar['amount'] . "</td>"; // Debit
        echo "<td></td>"; // Placeholder for credit
        echo "<td></td>"; // Placeholder for customer
    }

    echo "</tr>";
}
?>
       </tbody>
                                            <tfoot>
                                            <tr>
                                                <th>Date</th>
                                                <th>Transaction ID</th>
                                                <th>Account Charges</th>
                                                <th>Withdrawals</th>
                                                <th>Deposits</th>
                                                <th>Withdrawn By</th>
                                                <th>Deposited By</th>
                                                <th>Amount</th>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                           
                           
                           <!-- end table-responsive -->
                        </div>
                        </div>
                        </div>
                        
                     </div>
                  </div>
               </div>
               <!-- end row -->
            </div>
            <!-- container-fluid -->
         </div>
         <!-- End Page-content -->
         <!-- Transaction Modal -->
         <!-- end modal -->
         <!-- subscribeModal -->
         <!-- end modal -->
         <?php include 'footer.php' ?>
      </div>
      <!-- end main content-->
   </div>
   <!-- END layout-wrapper -->
   <!-- Right Sidebar -->
   
   <!-- /Right-bar -->
   <!-- Right bar overlay-->
   <div class="rightbar-overlay"></div>
   <!-- JAVASCRIPT -->
   
   <script src="assets/libs/jquery/jquery.min.js"></script>
   
   <script src="assets/libs/simplebar/simplebar.min.js"></script>
   <script src="assets/libs/node-waves/waves.min.js"></script>
   <!-- apexcharts -->
   <script src="assets/libs/apexcharts/apexcharts.min.js"></script>
   <!-- dashboard init -->
   <script src="assets/js/pages/dashboard.init.js"></script>
   <!-- App js -->
   <script src="assets/js/app.js"></script>
   
   

<!-- Required datatable js -->
        <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>
        <!-- Buttons examples -->
        <script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/jszip/jszip.min.js"></script>
        <script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
        <script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.colVis.min.js"></script>
        
        <!-- Responsive examples -->
        <script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js"></script>

        <!-- Datatable init js -->
        <script src="assets/js/pages/datatables.init.js"></script> 


</body>