<?php
ob_start();
session_start();
error_reporting(0);
include("../config/theconfig.php");
include("header.php");

// Check for a valid database connection
if (!isset($con) || !$con) {
    die("Database connection failed. Please check the config file.");
}

if (!(isset($_SESSION['customerid']))) {
    header('Location: login.php?error=nologin');
    exit(); // Always exit after a header redirect
}

// Fetch accounts using a prepared statement to prevent SQL injection
$stmt = mysqli_prepare($con, "SELECT * FROM accounts WHERE customerid=?");
mysqli_stmt_bind_param($stmt, "s", $_SESSION['customerid']);
mysqli_stmt_execute($stmt);
$acc = mysqli_stmt_get_result($stmt);
mysqli_stmt_close($stmt);

// The rest of your HTML and PHP code follows...
?>


    <body data-sidebar="colored">

    <!-- <body data-layout="horizontal" data-topbar="dark"> -->

        <!-- Begin page -->
        <div id="layout-wrapper">
           <?php include'header.php' ?>
            
           
            <!-- Left Sidebar End -->

            

            <!-- ============================================================== -->
            <!-- Start right Content here -->
            <!-- ============================================================== -->
            <div class="main-content">

                <div class="page-content">
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                    <h4 class="mb-sm-0 font-size-18">Bank Transfer</h4>

                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item active">Bank Transfer</li>
                                        </ol>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <!-- end page title -->

                        
                            

                        <div class="row">
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">Failed Transaction</h5>
                                         

                                        
										
										
										
										  <div class="alert alert-danger" role="alert">
                                                Your details are not correct, return to the <a href="javascript: void(0);" class="alert-link">transfer page</a>. to try again.
                                                </div>
										
                                            
				
				
				
                                       
                                    </div>
                                    <!-- end card body -->
                                </div>
                                <!-- end card -->
                            </div>
                            <!-- end col -->
                        </div>
                        <!-- end row -->
                        
                    </div> <!-- container-fluid -->
                </div>
                <!-- End Page-content -->

                <?php include 'footer.php' ?>
                
            </div>
            <!-- end main content-->

        </div>
        <!-- END layout-wrapper -->


        <!-- Right bar overlay-->
        

        <!-- JAVASCRIPT -->
        <script src="assets/libs/jquery/jquery.min.js"></script>
       
        <script src="assets/libs/simplebar/simplebar.min.js"></script>
        <script src="assets/libs/node-waves/waves.min.js"></script>

        <script src="assets/js/app.js"></script>

    
