<?php
session_start();
// It's recommended to enable error reporting during development to catch issues.
// For a live site, you would set it to '0' or a lower level.
error_reporting(E_ALL);
ini_set('display_errors', 1);

// This file is assumed to contain the mysqli connection setup,
// e.g., $conn = mysqli_connect(...)
include("../marklled/alled.php");

include("header.php");

// Check if the user is logged in
if (!isset($_SESSION["adminid"])) {
    header("Location: login.php");
    exit();
}

// Check if the connection variable exists from the included file
if (!isset($conn) || !$conn) {
    die("Database connection failed. Check your config file.");
}

// Execute the query using mysqli_query
$sql = "select * from loantype";
$loantype_result = mysqli_query($conn, $sql);

// Check if the query was successful
if (!$loantype_result) {
    die("Query failed: " . mysqli_error($conn));
}
?>
<div class="dt-content-wrapper">

    <div class="dt-content">

        <div class="dt-page__header">
            <h1 class="dt-page__title">All Loans</h1>
        </div>
        <div class="row">

            <div class="col-xl-12">

                <div class="dt-entry__header">

                    <div class="dt-entry__heading">
                        <h3 class="dt-entry__title">Active Loan Plans</h3>
                    </div>
                    </div>
                <div class="dt-card">

                    <div class="dt-card__body">

                        <div class="table-responsive">
                            <meta name="viewport" content="width=device-width, initial-scale=1.0">
                            <style>
                                * {
                                    box-sizing: border-box;
                                }

                                .columns {
                                    float: left;
                                    width: 33.3%;
                                    padding: 8px;
                                }

                                .price {
                                    list-style-type: none;
                                    border: 1px solid #eee;
                                    margin: 0;
                                    padding: 0;
                                    -webkit-transition: 0.3s;
                                    transition: 0.3s;
                                }

                                .price:hover {
                                    box-shadow: 0 8px 12px 0 rgba(0, 0, 0, 0.2)
                                }

                                .price .header {
                                    background-color: #111;
                                    color: white;
                                    font-size: 25px;
                                }

                                .price li {
                                    border-bottom: 1px solid #eee;
                                    padding: 20px;
                                    text-align: center;
                                }

                                .price .grey {
                                    background-color: #eee;
                                    font-size: 20px;
                                }

                                .button {
                                    background-color: #4CAF50;
                                    border: none;
                                    color: white;
                                    padding: 10px 25px;
                                    text-align: center;
                                    text-decoration: none;
                                    font-size: 18px;
                                }

                                @media only screen and (max-width: 600px) {
                                    .columns {
                                        width: 100%;
                                    }
                                }
                            </style>
                            </head>
                            <body>
                                <?php
                                // Loop through the results using mysqli_fetch_assoc
                                while ($loantypes = mysqli_fetch_assoc($loantype_result)) {
                                    echo "
                                    <div class='columns'>
                                        <ul class='price'>
                                            <li class='header' style='background-color:#512DA8'>" . htmlspecialchars($loantypes['loantype']) . "</li>
                                            <li class='grey'>" . htmlspecialchars($loantypes['interest']) . " % Interest</li>
                                            <li>" . htmlspecialchars($loantypes['minimumamt']) . " Minimum</li>
                                            <li>" . htmlspecialchars($loantypes['maximumamt']) . " Maximum</li>
                                            <li class='grey'><a href='#' class='btn btn-primary'>Edit Plan</a></li>
                                        </ul>
                                    </div>
                                    ";
                                }
                                ?>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            include('footer.php');
            // Close the database connection
            mysqli_close($conn);
            ?>

            <script src="../assets/node_modules/datatables.net/js/jquery.dataTables.js"></script>
            <script src="../assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"></script>
            <script src="../assets/js/custom/data-table.js"></script>