<?php
session_start();
// It's recommended to enable error reporting during development to catch issues.
// For a live site, you would set it to '0' or a lower level.



// This file is assumed to contain the mysqli connection setup,
// e.g., $conn = mysqli_connect(...)
include("../config/theconfig.php");

include("header.php");

// Check if the user is logged in
if (!isset($_SESSION["adminid"])) {
    header("Location: login.php");
    exit();
}

// Check if the connection variable exists from the included file
if (!isset($conn) || !$conn) {
    die("Database connection failed. Check your config file.");
}

// Execute the query using mysqli_query
$sql = "select * from transfers";
$loan_result = mysqli_query($conn, $sql);

// Check if the query was successful
if (!$loan_result) {
    die("Query failed: " . mysqli_error($conn));
}
?>
<div class="dt-content-wrapper">

    <div class="dt-content">

        <div class="dt-page__header">
            <h1 class="dt-page__title">View Fund Transfers</h1>
        </div>
        <div class="row">
            <div class="col-xl-12">

                <div class="dt-entry__header">

                    <div class="dt-entry__heading">
                        <h3 class="dt-entry__title">All Fund Transfers</h3>
                    </div>
                    </div>
                <div class="dt-card">

                    <div class="dt-card__body">

                        <div class="table-responsive">

                            <table id="data-table" class="table table-striped table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th>Receiver's Name</th>
                                    <th>Receiver's Bank</th>
                                    <th>Bank Address</th>
                                    <th>Bank Account No</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                // Loop through the results using mysqli_fetch_assoc
                                while ($arrvar = mysqli_fetch_assoc($loan_result)) {
                                    echo "<tr>";
                                    echo "<td>" . htmlspecialchars($arrvar['name']) . "</td>";
                                    echo "<td>" . htmlspecialchars($arrvar['bank']) . "</td>";
                                    echo "<td>" . htmlspecialchars($arrvar['address']) . "</td>";
                                    echo "<td>" . htmlspecialchars($arrvar['receiver']) . "</td>";
                                    echo "<td>$cur " . htmlspecialchars($arrvar['amount']) . "</td>";
                                    echo "<td>" . htmlspecialchars($arrvar['date']) . "</td>";
                                    echo "<td>";
                                    if ($arrvar['status'] == '0') {
                                        echo "<span class='badge badge-pill badge-danger mb-1 mr-1'>Pending</span>";
                                    } elseif ($arrvar['status'] == '1') {
                                        echo "<span class='badge badge-pill badge-success mb-1 mr-1'>Successful</span>";
                                    }
                                    echo "</td>";
                                    echo "</tr>";
                                }
                                ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <th>Receiver's Name</th>
                                    <th>Receiver's Bank</th>
                                    <th>Bank Address</th>
                                    <th>Bank Account No</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    include('footer.php');
    // Close the database connection
    mysqli_close($conn);
    ?>

    <script src="../assets/node_modules/datatables.net/js/jquery.dataTables.js"></script>
    <script src="../assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"></script>
    <script src="../assets/js/custom/data-table.js"></script>