<?php
session_start();
error_reporting(0);
include("../config/theconfig.php");

include("header.php");
if(!($_SESSION["adminid"]))
{
		header("Location: login.php");
    exit(); // Always exit after a header redirect
}

// Query for system settings
$loan = mysqli_query($conn, "select * from system_settings");

?>
<div class="dt-content-wrapper">

    <div class="dt-content">

        <div class="dt-page__header">
            <h1 class="dt-page__title">System Settings</h1>
        </div>
        <div class="col-xl-12 col-md-6 order-xl-4">

            <div class="dt-card bg- text-black">

                <div class="dt-card__header">

                    <div class="dt-card__heading">
                        <div class="d-flex align-items-center">
                            <i class="icon icon-settings icon-fw icon-2x text-black mr-2"></i>
                            <h3 class="dt-card__title text-black">System Settings</h3>
                        </div>
                    </div>
                    <?php
                    if (isset($_POST["button"])) {
                        // The original code's check for mysql_num_rows() is illogical for an update query.
                        // The prepared statement will handle the update correctly.
                        $sql_update = "UPDATE system_settings SET bank_name=?, theme_color=?, email=?, phone=?, currency=?"; // Assuming a single row for settings
                        
                        if ($stmt = mysqli_prepare($conn, $sql_update)) {
                            // Bind parameters to the query
                            mysqli_stmt_bind_param($stmt, "sssss", $_POST['name'], $_POST['color'], $_POST['email'], $_POST['phone'], $_POST['currency']);

                            // Execute the statement
                            if (mysqli_stmt_execute($stmt)) {
                                echo "<script>swal('Success!', 'System Settings Updated Successfully!', 'success')</script>";
                            } else {
                                die('Error: ' . mysqli_error($conn));
                            }
                            mysqli_stmt_close($stmt);
                        } else {
                            die('Error preparing statement: ' . mysqli_error($conn));
                        }
                    }
                    ?>
                </div>
                <div class="dt-card__body pb-3">
                    <form method="post" action="">

                        <div class="row">
                            <?php
                            $results = mysqli_query($conn, "SELECT * FROM system_settings");
                            $bankname = $currency = $email = $phone = $status = $theme = '';
                            if ($results) {
                                if ($arrow = mysqli_fetch_array($results)) {
                                    $bankname = $arrow['bank_name'];
                                    $currency = $arrow['currency'];
                                    $email = $arrow['email'];
                                    $phone = $arrow['phone'];
                                    $status = $arrow['status'];
                                    $theme = $arrow['theme_color'];
                                }
                                mysqli_free_result($results);
                            }
                            ?>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Currency</label>
                                    <select name="currency" id="country" class="custom-select custom-select-sm">
                                        <?php
                                        $acc = mysqli_query($conn, "select * from currency");
                                        if ($acc) {
                                            while ($rowsacc = mysqli_fetch_array($acc)) {
                                                $selected = ($rowsacc['code'] == $currency) ? 'selected' : '';
                                                echo "<option value='" . htmlspecialchars($rowsacc['code']) . "' {$selected}>" . htmlspecialchars($rowsacc['name']) . "</option>";
                                            }
                                            mysqli_free_result($acc);
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Bank Name</label>
                                    <input required name="name" value="<?php echo htmlspecialchars($bankname); ?>" class="form-control">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Official E-mail</label>
                                    <input name="email" value="<?php echo htmlspecialchars($email); ?>" class="form-control">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Official Phone Number</label>
                                    <input name="phone" value="<?php echo htmlspecialchars($phone); ?>" class="form-control">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <input required hidden type="text" value="<?php echo htmlspecialchars($status); ?>" name="status" class="form-control">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Theme Color</label>
                                    <input name="color" value="<?php echo htmlspecialchars($theme); ?>" class="form-control">
                                </div>
                            </div>
                            </div>
                        </div>
                <div class="px-7 py-5 border-top border-width-2 border-black-transparent">
                    <tr>
                        <td colspan="2"><div align="right">
                            <input type="submit" name="button" id="button" class="btn btn-secondary" value="Update System" />
                        </div></td>
                    </tr>
                </div>
                </form>
            </div>
            </div>
        <div class="dt-entry__header">
        </div>

        </div>
    <?php include'footer.php' ?>

</body>
<?php include 'footer.php' ?>
<script>
    function updateTheme() {
        var themeColor = document.querySelector('input[name="color"]').value;
        // You can use the themeColor variable to update the site's theme dynamically
        // e.g., document.body.style.backgroundColor = themeColor;
    }
</script>

<br>
<br>
<br>
<br>

<div class="text-center mt-4">
    <p>This tutorial shows you how to convert code from the deprecated mysql functions to the modern, secure mysqli functions.</p>
</div>
<br>

This video provides a practical guide on converting from the deprecated `mysql` extension to the secure `mysqli` extension in PHP, which is directly relevant to the code conversion task.