<?php
session_start();


include("../config/theconfig.php");
include("header.php");

// Check for admin session
if (!isset($_SESSION["adminid"])) {
    header("Location: login.php");
    exit(); // Always exit after a header redirect
}

// Handle Delete Operation
if (isset($_POST["delete"])) {
    // Use a prepared statement to prevent SQL injection
    $stmt = mysqli_prepare($conn, "DELETE FROM staff WHERE empid=?");
    mysqli_stmt_bind_param($stmt, "i", $_POST['emp']);
    
    if (mysqli_stmt_execute($stmt)) {
        if (mysqli_stmt_affected_rows($stmt) == 1) {
            echo "<script>swal('Successful!', 'Staff Account Has Been Deleted!', 'success')</script>";
        } else {
            echo "<script>swal('Failed!', 'Failed to delete staff account or account not found!', 'error')</script>";
        }
    } else {
        echo "<script>swal('Error!', 'Error deleting record: " . mysqli_error($conn) . "', 'error')</script>";
    }
    mysqli_stmt_close($stmt);
}

// Fetch all staff members
$stmt_staff = mysqli_prepare($conn, "SELECT * FROM staff");
mysqli_stmt_execute($stmt_staff);
$result_staff = mysqli_stmt_get_result($stmt_staff);
?>
<div class="dt-content-wrapper">

    <div class="dt-content">

        <div class="dt-page__header">
            <h1 class="dt-page__title">Manage Bank Staff</h1>
        </div>
        <div class="row">
            
            <div class="col-xl-12">

                <div class="dt-entry__header">

                    <div class="dt-entry__heading">
                        <h3 class="dt-entry__title">All Staff</h3>
                    </div>
                    </div>
                <div class="dt-card">

                    <div class="dt-card__body">
                        
                        <a href="createstaff.php"><button class='btn btn-secondary'>Create New Staff</button></a>
                        <br>
                        
                        <div class="table-responsive">
                            <table id="data-table" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Staff Name</th>
                                        <th>Staff Login ID</th>
                                        <th>Staff Password</th>
                                        <th>Staff E-mail</th>
                                        <th>Staff Phone</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    while ($arrvar = mysqli_fetch_assoc($result_staff)) {
                                        echo "<tr>";
                                        echo "<td>" . htmlspecialchars($arrvar['firstname']) . " " . htmlspecialchars($arrvar['lastname']) . "</td>";
                                        echo "<td>" . htmlspecialchars($arrvar['username']) . "</td>";
                                        echo "<td>" . htmlspecialchars($arrvar['password']) . "</td>";
                                        echo "<td>" . htmlspecialchars($arrvar['email']) . "</td>";
                                        echo "<td>" . htmlspecialchars($arrvar['phone']) . "</td>";
                                        echo "<td>
                                                <form method='post' action='managestaff.php' onsubmit=\"return confirm('Are you sure you want to delete this staff account?');\">
                                                    <input type='hidden' value='" . htmlspecialchars($arrvar['empid']) . "' name='emp'>
                                                    <input type='submit' class='btn btn-secondary' name='delete' value='Delete' />
                                                </form>
                                              </td>";
                                        echo "</tr>";
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Staff Name</th>
                                        <th>Staff Login ID</th>
                                        <th>Staff Password</th>
                                        <th>Staff E-mail</th>
                                        <th>Staff Phone</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php 
mysqli_stmt_close($stmt_staff); // Close the statement after fetching
include 'footer.php';
// The database connection should be closed at the end of the script.
?>
    
<script src="../assets/node_modules/datatables.net/js/jquery.dataTables.js"></script>
<script src="../assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../assets/js/custom/data-table.js"></script>