<?php
session_start();
error_reporting(0);
include("../config/theconfig.php");
include("header.php");

if (!isset($_SESSION['customerid'])) {
    header('Location: login.php?error=nologin');
    exit();
}

$successresult = "";

if (isset($_POST["adda"])) {
    // Using a prepared statement for the INSERT query
    $sql = "INSERT INTO loanpayment (payment_id, customer_id, loan_amt, interest, total_amt, paid, balance, paid_date)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = mysqli_prepare($conn, $sql);
    
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "ssssssss", $_POST['payment_id'], $_POST['customer_id'], $_POST['loan_amt'], $_POST['interest'], $_POST['total_amt'], $_POST['paid'], $_POST['balance'], $_POST['paydate']);
        
        if (mysqli_stmt_execute($stmt)) {
            echo "1 record added";
        } else {
            die('Error: ' . mysqli_error($conn));
        }
        mysqli_stmt_close($stmt);
    } else {
        die('Error preparing statement: ' . mysqli_error($conn));
    }
}

if (isset($_POST["update"])) {
    // Using a prepared statement for the UPDATE query
    $sql = "UPDATE loanpayment SET payment_id=?, customer_id=?, loan_amt=?, interest=?, total_amt=?, paid=?, balance=?, paid_date=? WHERE payment_id=?";
    
    $stmt = mysqli_prepare($conn, $sql);
    
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "sssssssss", $_POST['payment_id'], $_POST['customer_id'], $_POST['loan_amt'], $_POST['interest'], $_POST['total_amt'], $_POST['paid'], $_POST['balance'], $_POST['paydate'], $_POST['payment_id']);
        
        if (mysqli_stmt_execute($stmt)) {
            $updt = mysqli_stmt_affected_rows($stmt);
            if ($updt == 1) {
                $successresult = "Record updated successfully";
            }
        } else {
            die('Error: ' . mysqli_error($conn));
        }
        mysqli_stmt_close($stmt);
    } else {
        die('Error preparing statement: ' . mysqli_error($conn));
    }
}

?>
<div class="dt-content-wrapper">

    <div class="dt-content">

        <div class="dt-page__header">
            <h1 class="dt-page__title">My Loan Payments</h1>
        </div>
        <div class="row">

            <div class="col-xl-12">

                <div class="dt-entry__header">

                    <div class="dt-entry__heading">
                        <h3 class="dt-entry__title">View Loan Payment</h3>
                    </div>
                    </div>
                <div class="dt-card">

                    <div class="dt-card__body">

                        <div class="table-responsive">

                            <table id="data-table" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Payment ID</th>
                                        <th>Loan Number</th>
                                        <th>Amount Paid</th>
                                        <th>Payment Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $result = mysqli_query($conn, "SELECT * FROM loanpayment");
                                    while ($arrvar = mysqli_fetch_array($result)) {
                                        echo "<tr>
                                            <td height='46'>LOPAY{$arrvar['id']}</td>
                                            <td>{$arrvar['loanid']}</td>
                                            <td>{$arrvar['paidamt']}</td>
                                            <td>{$arrvar['date']}</td>
                                        </tr>";
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Payment ID</th>
                                        <th>Loan Number</th>
                                        <th>Amount Paid</th>
                                        <th>Payment Date</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php include 'footer.php' ?>

    <script src="../assets/node_modules/datatables.net/js/jquery.dataTables.js"></script>
    <script src="../assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"></script>
    <script src="../assets/js/custom/data-table.js"></script>