<?php
session_start();
error_reporting(0);
include("../config/theconfig.php");

include("header.php");

if (!isset($_SESSION["adminid"])) {
    header("Location: login.php");
    exit();
}

$loan = mysqli_query($conn, "SELECT * FROM loan");
?>
<div class="dt-content-wrapper">

    <div class="dt-content">

        <div class="dt-page__header">
            <h1 class="dt-page__title">My Loan</h1>
        </div>
        <div class="row">
            <?php
            $successresult = "";
            if (isset($_POST["approve"])) {
                // Use prepared statement to prevent SQL injection
                $stmt = mysqli_prepare($conn, "UPDATE loan SET status = 1 WHERE loanid = ?");
                mysqli_stmt_bind_param($stmt, "i", $_POST['payto']);
                mysqli_stmt_execute($stmt);

                if (mysqli_stmt_affected_rows($stmt) == 1) {
                    $successresult = "Transaction successful";
                    echo "<script>swal('Successful!', 'Loan Application Has Been Approved!', 'success')</script>";
                } else {
                    $successresult = "Failed to approve loan.";
                    echo "Error: " . mysqli_error($conn);
                }
                mysqli_stmt_close($stmt);
            }

            if (isset($_POST["disburse"])) {
                // Use prepared statement to prevent SQL injection
                $stmt = mysqli_prepare($conn, "UPDATE loan SET status = 2, balance = ? WHERE loanid = ?");
                mysqli_stmt_bind_param($stmt, "si", $_POST['bal'], $_POST['payto']);
                mysqli_stmt_execute($stmt);

                if (mysqli_stmt_affected_rows($stmt) == 1) {
                    $successresult = "Transaction successful";
                    echo "<script>swal('Successful!', 'Fund Has Been Disbursed And Loan Is Active And Running Now', 'success')</script>";
                } else {
                    $successresult = "Failed to disburse funds.";
                    echo "Error: " . mysqli_error($conn);
                }
                mysqli_stmt_close($stmt);
            }
            ?>

            <div class="col-xl-12">
                <div class="dt-entry__header">
                    <div class="dt-entry__heading">
                        <h3 class="dt-entry__title">View Loan</h3>
                    </div>
                    </div>
                <div class="dt-card">
                    <div class="dt-card__body">
                        <div class="table-responsive">
                            <table id="data-table" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Loan Type</th>
                                        <th>Loan Account</th>
                                        <th>Loan Amount</th>
                                        <th>Loan Interest</th>
                                        <th>Application Date</th>
                                        <th>Action</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 1;
                                    while ($arrvar = mysqli_fetch_array($loan)) {
                                        echo "<tr>
                                            <td>{$arrvar['loantype']}</td>
                                            <td>{$arrvar['loannumber']}</td>
                                            <td>{$cur} {$arrvar['loanamt']}</td>
                                            <td>{$arrvar['interest']} %</td>
                                            <td>{$arrvar['startdate']}</td>
                                            <td>
                                                <form method='post' action='viewloanapp.php'>
                                                    <input hidden value='{$arrvar['loanid']}' name='payto'>
                                                    <input hidden value='{$arrvar['customerid']}' name='custid'>
                                                    <input type='submit' class='btn btn-secondary' name='pay' value='View' />
                                                </form>
                                            </td>
                                            <td>";
                                        if ($arrvar['status'] == '0') {
                                            echo "<span class='badge badge-pill badge-danger mb-1 mr-1'>Pending Approval</span>";
                                        }
                                        if ($arrvar['status'] == '1') {
                                            echo "<span class='badge badge-pill badge-success mb-1 mr-1'>Approved</span>";
                                        }
                                        if ($arrvar['status'] == '2') {
                                            echo "<span class='badge badge-pill badge-info mb-1 mr-1'>Fund Disbursed</span>";
                                        }
                                        echo "</td></tr>";
                                        $i++;
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Loan Type</th>
                                        <th>Loan Account</th>
                                        <th>Loan Amount</th>
                                        <th>Loan Interest</th>
                                        <th>Application Date</th>
                                        <th>Action</th>
                                        <th>Status</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php include 'footer.php' ?>

    <script src="../assets/node_modules/datatables.net/js/jquery.dataTables.js"></script>
    <script src="../assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"></script>
    <script src="../assets/js/custom/data-table.js"></script>