<?php
session_start();
error_reporting(0);
include("../config/theconfig.php");

include("header.php");

// Check if the user is an authenticated admin. If not, redirect to the login page.
if (!isset($_SESSION["adminid"])) {
    header("Location: login.php");
    exit();
}

// Assuming `theconfig.php` establishes a mysqli connection in a variable named `$conn`.
// This is a crucial step for preventing SQL injection and other vulnerabilities.
if (!isset($conn)) {
    die("Database connection variable \$conn is not set. Please check theconfig.php.");
}

// Retrieve all transactions where the transaction type is 'debit'.
// The original code used the deprecated `mysql_query()`. This has been updated to `mysqli_query()`
// for improved security and modern compatibility.
$custarray = mysqli_query($conn, "SELECT * FROM transactions WHERE type = 'debit'");
?>
<div class="dt-content-wrapper">

    <div class="dt-content">

        <div class="dt-page__header">
            <h1 class="dt-page__title">Debit History</h1>
        </div>
        <div class="row">

            <div class="col-xl-12">

                <div class="dt-entry__header">

                    <div class="dt-entry__heading">
                        <h3 class="dt-entry__title">Recent Debits</h3>
                    </div>
                    </div>
                <div class="dt-card">

                    <div class="dt-card__body">

                        <div class="table-responsive">

                            <table id="data-table" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Account Number</th>
                                        <th>Amount</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // Loop through the results and display each debit transaction.
                                    while ($customer = mysqli_fetch_array($custarray)) {
                                        echo "<tr>";
                                        // Use `htmlspecialchars` to prevent Cross-Site Scripting (XSS) attacks.
                                        echo "<td>&nbsp;" . htmlspecialchars($customer['charged']) . "</td>";
                                        echo "<td>" . htmlspecialchars($customer['amount']) . "</td>";
                                        echo "<td>&nbsp;" . htmlspecialchars($customer['paymentdate']) . "</td>";
                                        echo "</tr>";
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Account Number</th>
                                        <th>Amount</th>
                                        <th>Date</th>
                                    </tr>
                                </tfoot>
                            </table>
                            <div class="text-right">
                                <button type="button" class="btn btn-primary" onclick="window.print()">Print Details</button>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php include 'footer.php'; ?>

<script src="../assets/node_modules/datatables.net/js/jquery.dataTables.js"></script>
<script src="../assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../assets/js/custom/data-table.js"></script>