<?php
session_start();
error_reporting(0);
include("../config/theconfig.php");

include("header.php");

// Check for admin session, if not set, redirect to login page.
if (!isset($_SESSION["adminid"])) {
    header("Location: login.php");
    exit();
}

// Assuming the included file 'theconfig.php' establishes a database connection
// using mysqli. If it's using the old mysql_* functions, we need to adapt.
// This example assumes it's updated to use mysqli.
if (!isset($conn)) {
    die("Connection variable \$conn not set. Please check theconfig.php.");
}

// Select all customers from the database.
$custarray = mysqli_query($conn, "SELECT * FROM customers");
?>
<div class="dt-content-wrapper">
    <div class="dt-content">
        <div class="dt-page__header">
            <h1 class="dt-page__title">Transfer History</h1>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="dt-entry__header">
                    <div class="dt-entry__heading">
                        <h3 class="dt-entry__title">Recent Transfer</h3>
                    </div>
                    </div>
                <div class="dt-card">
                    <div class="dt-card__body">
                        <div class="table-responsive">
                            <table id="data-table" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Customer ID</th>
                                        <th>LOGIN ID</th>
                                        <th>NAME</th>
                                        <th>STATUS</th>
                                        <th>LOCATION</th>
                                        <th>ACCOUNT OPENING DATE</th>
                                        <th>LAST LOGIN</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // Loop through the query results and display customer data
                                    while ($customer = mysqli_fetch_array($custarray)) {
                                        echo "<tr>";
                                        echo "<td>&nbsp;" . htmlspecialchars($customer['customerid']) . "</td>";
                                        echo "<td>&nbsp;" . htmlspecialchars($customer['loginid']) . "</td>";
                                        echo "<td>" . htmlspecialchars($customer['firstname']) . "&nbsp;" . htmlspecialchars($customer['lastname']) . "</td>";
                                        echo "<td>&nbsp;" . htmlspecialchars($customer['accstatus']) . "</td>";
                                        echo "<td>&nbsp;" . htmlspecialchars($customer['city']) . "<br>" . htmlspecialchars($customer['state']) . "<br>" . htmlspecialchars($customer['country']) . "</td>";
                                        echo "<td>&nbsp;" . htmlspecialchars($customer['accopendate']) . "</td>";
                                        echo "<td>&nbsp;" . htmlspecialchars($customer['lastlogin']) . "</td>";
                                        echo "<th>&nbsp;<a href='debit.php?custid=" . htmlspecialchars($customer['customerid']) . "'>Debit Account</a>&nbsp;</th>";
                                        echo "</tr>";
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Customer ID</th>
                                        <th>LOGIN ID</th>
                                        <th>NAME</th>
                                        <th>STATUS</th>
                                        <th>LOCATION</th>
                                        <th>ACCOUNT OPENING DATE</th>
                                        <th>LAST LOGIN</th>
                                        <th>ACTION</th>
                                    </tr>
                                </tfoot>
                            </table>
                            <tr>
                                <td colspan="2">
                                    <div align="right">
                                        <button type="button" class="btn btn-secondary" onclick="window.print()">Print Customers' Detail</button>
                                    </div>
                                </td>
                            </tr>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php include 'footer.php' ?>

<script src="../assets/node_modules/datatables.net/js/jquery.dataTables.js"></script>
<script src="../assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../assets/js/custom/data-table.js"></script>