<?php
   session_start();
   error_reporting(0);
   include("../config/theconfig.php");
   include("header.php");

   if (!isset($_SESSION["adminid"])) {
       header("Location: login.php");
       exit();
   }

   // Get total number of customers
   $query = "SELECT * FROM customers";
   $users = mysqli_query($con, $query);
   $totalCustomers = mysqli_num_rows($users);

   // Get last user login
   $query = "SELECT MAX(lastlogin) FROM customers";
   $result = mysqli_query($con, $query);
   $lastLogin = mysqli_fetch_array($result)[0];

   // Get total saved amount
   $query = "SELECT SUM(accountbalance) FROM accounts";
   $result = mysqli_query($con, $query);
   $totalSaved = mysqli_fetch_array($result)[0];

   // Get the latest saved amount
   $query = "SELECT * FROM saved";
   $result = mysqli_query($con, $query);
   $savedAmount = mysqli_fetch_array($result)['amount'];

   // Get the last loan amount
   $query = "SELECT * FROM loan";
   $result = mysqli_query($con, $query);
   $lastLoan = mysqli_fetch_array($result)['loanamt'];
?>

<!-- Site Content Wrapper -->
<div class="dt-content-wrapper">
   <div class="dt-content">
      <div class="dt-page__header">
         <h1 class="dt-page__title">Admin Dashboard</h1>
      </div>

      <div class="row">
         <!-- Total Customers Card -->
         <div class="col-xl-3 col-sm-6">
            <div class="dt-card">
               <div class="dt-card__body d-flex flex-sm-column">
                  <div class="mb-sm-7 mr-7 mr-sm-0">
                     <i class="icon icon-users dt-icon-bg bg-primary text-primary"></i>
                  </div>
                  <div class="flex-1">
                     <div class="d-flex align-items-center mb-2">
                        <span class="h4 mb-0 font-weight-medium mr-2"><?php echo $totalCustomers; ?> Customers</span>
                     </div>
                     <div class="h5 mb-2">Total Customers</div>
                     <p class="card-text text-light-gray f-12">
                        Last user login: <?php echo $lastLogin; ?>
                     </p>
                  </div>
               </div>
            </div>
         </div>

         <!-- Total Saved Card -->
         <div class="col-xl-3 col-sm-6">
            <div class="dt-card">
               <div class="dt-card__body d-flex flex-sm-column">
                  <div class="mb-sm-7 mr-7 mr-sm-0">
                     <i class="icon icon-revenue dt-icon-bg bg-success text-success"></i>
                  </div>
                  <div class="flex-1">
                     <div class="d-flex align-items-center mb-2">
                        <span class="h4 mb-0 font-weight-medium mr-2"><?php echo $cur . ' ' . number_format($totalSaved, 2); ?></span>
                     </div>
                     <div class="h5 mb-2">Total Saved</div>
                     <p class="card-text text-light-gray f-12">
                        Last Saved: <?php echo $cur . number_format($savedAmount, 2); ?>
                     </p>
                  </div>
               </div>
            </div>
         </div>

         <!-- WhatsApp Message Card -->
         <div class="col-xl-3 col-sm-6">
            <div class="dt-card">
               <div class="dt-card__body d-flex flex-sm-column">
                  <div class="mb-sm-7 mr-7 mr-sm-0">
                     <i class="icon icon-message dt-icon-bg bg-warning text-warning"></i>
                  </div>
                  <div class="flex-1">
                     <div class="d-flex align-items-center mb-2">
                        <span class="h4 mb-0 font-weight-medium mr-2">📞 WhatsApp Message</span>
                     </div>
                     <div class="h5 mb-2">
                        <a href="https://wa.me/+2349025010434">📱 +2349025010434</a>
                     </div>
                     <p class="card-text text-light-gray f-12">
                        <b>Contact the <font color="#33cf6a"><a href="https://wa.me/+2349161382884">Web Developer</a></font></b>
                     </p>
                  </div>
               </div>
            </div>
         </div>

         <!-- Loan Info Card -->
         <div class="col-xl-3 col-sm-6">
            <div class="dt-card">
               <div class="dt-card__body d-flex flex-sm-column">
                  <div class="mb-sm-7 mr-7 mr-sm-0">
                     <i class="icon icon-loan dt-icon-bg bg-danger text-danger"></i>
                  </div>
                  <div class="flex-1">
                     <div class="d-flex align-items-center mb-2">
                        <span class="h4 mb-0 font-weight-medium mr-2">Loan Info</span>
                     </div>
                     <div class="h5 mb-2">Last Loan Amount</div>
                     <p class="card-text text-light-gray f-12">
                        <?php echo $cur . number_format($lastLoan, 2); ?>
                     </p>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

<?php include("footer.php"); ?>
