<?php
session_start();
error_reporting(0);
include("../config/theconfig.php");

include("header.php");

if (!isset($_SESSION["adminid"])) {
    header("Location:login.php");
    exit();
}

$dt = date("Y-m-d h:i:s");



$custid = $_GET['custid'];

// Fetch customer information
$sql = "SELECT * FROM customers WHERE customerid='$custid'";
$result = mysqli_query($conn, $sql);

if ($result) {
    $row = mysqli_fetch_array($result, MYSQLI_ASSOC);
    $custname = $row['firstname'] . " " . $row['lastname'];
    $ifsccode = $row['ifsccode'];
    $loginid = $row['loginid'];
    $accstatus = $row['accstatus'];
    $city = $row['city'];
    $state = $row['state'];
    $country = $row['country'];
    $accopendate = $row['accopendate'];
    $lastlogin = $row['lastlogin'];
    $email = $row['email'];
    $accountbalance = $row['balance'];
} else {
    echo "Error: " . mysqli_error($conn);
}


// Handling Credit Form
if (isset($_POST['credit'])) {
    // Inserting transaction
    $amount = $_POST['amount'];
    $paymentdate = $_POST['paymentdate'];

    $stmt = mysqli_prepare($conn, "INSERT INTO transactions (cashier, type, paymentdate, receiveid, amount, paymentstat) VALUES (?, 'Credit', ?, ?, ?, 'active')");
    mysqli_stmt_bind_param($stmt, "issi", $_SESSION['adminid'], $paymentdate, $custid, $amount);
    mysqli_stmt_execute($stmt);

    // Inserting into saved table
    $stmt = mysqli_prepare($conn, "INSERT INTO saved (userid, amount, status) VALUES (?, ?, 'active')");
    mysqli_stmt_bind_param($stmt, "id", $custid, $amount);
    mysqli_stmt_execute($stmt);

    // Updating account balance
    $stmt = mysqli_prepare($conn, "UPDATE accounts SET accountbalance = accountbalance + ? WHERE customerid = ?");
    mysqli_stmt_bind_param($stmt, "di", $amount, $custid);
    mysqli_stmt_execute($stmt);

    // Display success message
    echo "<script>swal('Success', 'Account credited successfully!', 'success')</script>";
}

// Fetch account details for display
$sql_accounts = "SELECT * FROM accounts WHERE customerid='$custid'";
$result_accounts = mysqli_query($conn, $sql_accounts);
?>

<!-- Site Content Wrapper -->
<div class="dt-content-wrapper">
    <div class="dt-content">
        <div class="dt-page__header">
            <h1 class="dt-page__title">Credit Customer</h1>
        </div>

        <div class="row">
            <div class="col-xl-12">
                <div class="dt-entry__header">
                    <div class="dt-entry__heading">
                        <h3 class="dt-entry__title">Credit Account</h3>
                    </div>
                </div>

                <div class="dt-card">
                    <div class="dt-card__body">
                        <div class="table-responsive">
                            <blockquote>
                                <table id="data-table" class="table table-striped table-bordered table-hover">
                                    <tr>
                                        <th colspan="5"><strong>CUSTOMER ACCOUNTS</strong></th>
                                    </tr>
                                    <tr>
                                        <th><strong>ACCOUNT NO</strong></th>
                                        <th><strong>STATUS</strong></th>
                                        <th><strong>OPEN DATE</strong></th>
                                        <th><strong>ACCOUNT TYPE</strong></th>
                                        <th><strong>BALANCE</strong></th>
                                    </tr>
                                    <?php
                                    while ($arrow = mysqli_fetch_array($result_accounts, MYSQLI_ASSOC)) {
                                        echo "<tr>
                                                <td>{$arrow['accno']}</td>
                                                <td>{$arrow['accstatus']}</td>
                                                <td>{$arrow['accopendate']}</td>
                                                <td>{$arrow['accounttype']}</td>
                                                <td>{$cur} {$arrow['accountbalance']}</td>
                                              </tr>";
                                    }
                                    ?>
                                </table>
                            </blockquote>
                            <div align="right">
                                <input type="button" class="btn btn-secondary" data-toggle="modal" data-target="#myModal" value="Credit Account">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Credit -->
    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Credit User</h4>
                </div>
                <div class="modal-body">
                    <form method="post" action="">
                        <input type="hidden" value="<?php echo $custid ?>" name="custid">
                        <div class="form-group">
                            <label>Enter Amount To Credit</label>
                            <input type="number" name="amount" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>Transaction Date</label>
                            <input type="datetime-local" name="paymentdate" class="form-control" required>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    <input name="credit" type="submit" value="Credit" class="btn btn-secondary">
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script src="../assets/node_modules/datatables.net/js/jquery.dataTables.js"></script>
<script src="../assets/node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"></script>
<script src="../assets/js/custom/data-table.js"></script>

<?php
// Close MySQL connection
mysqli_close($conn);
?>
